﻿using System;
using Server;
using Server.Targeting;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class Prsten : GoldRing
	{
		public override int ArtifactRarity{ get{ return 100; } }
		public DateTime m_NextSpecial;
		
		public DateTime NextSpecial
		{
			get { return m_NextSpecial; }
			set { m_NextSpecial = value; }
		}
		
		[Constructable]
		public Prsten() : base()
		{
			Name = "Prsten";
			Hue = 1166;
			LootType = LootType.Blessed;
			Attributes.AttackChance = 15;
			Attributes.BonusDex = 5;
			Attributes.BonusHits = 20;
			Attributes.BonusInt = 5;
			Attributes.BonusMana = 20;
			Attributes.BonusStr = 5;
			Attributes.CastRecovery = 2;
			Attributes.CastSpeed = 2;
			Attributes.Luck = 200;
			Attributes.RegenHits = 2;
			Attributes.RegenMana = 3;
			Attributes.SpellDamage = 25;
			Resistances.Physical = 7;
			Resistances.Cold = 5;
			Resistances.Fire = 5;
			Resistances.Poison = 5;
			Resistances.Energy = 5;
			
			SkillBonuses.SetValues( 0, SkillName.EvalInt, 10.0 );
		}
		
		public override void OnDoubleClick( Mobile m )
		{
			if( Parent != m )
			{
				m.SendMessage( "Musis mit prsten nasazen aby sel pouzit!" );
			}
			else if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes prsten pouzit pokud s nekym obchodujes!" );
			}
			else
			{
				if ( DateTime.Now > m_NextSpecial )
				{
					PlayerMobile parent = this.Parent as PlayerMobile;
					if( parent != null && parent.Map != null )
					{
						parent.Target = new PrstenTarget( this );
					}
				}
				else
					m.SendMessage( "Jeste nemuzes prsten pouzit!" );
			}
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Convert Minions<basefont color=White>" );
		}

		public Prsten( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
		
		private class PrstenTarget : Target
		{
			private Prsten m_Prsten;
			
			public PrstenTarget( Prsten prsten ) : base( 10, false, TargetFlags.None )
			{
				m_Prsten = prsten;
			}

			protected override void OnTarget( Mobile m, object t )
			{
				if ( m == null )
					return;
				
				if ( t is BaseSummoned && DateTime.Now > m_Prsten.NextSpecial )
				{
					BaseSummoned sum = t as BaseSummoned;
					
					if ( sum != null && !sum.Summoned )
					{
						m_Prsten.NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 2.0 + (1.15 * Utility.RandomDouble()) );
						sum.Summoned = true;
						
						m.SendMessage( "Monstrum bylo obraceno proti svym spojencum!" );
					}
				}
				else
					m.SendMessage( "Toto neni vyvolany minion!" );
			}
		}
	}
}
